﻿using System;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal class NotNullReactiveProperty<T> : IReactiveProperty<T>
    {
        [NotNull]
        private readonly IReactiveProperty<T> _inner;

        public bool HasValue => _inner is { HasValue: true, Value: not null };

        [NotNull]
        public T Value
        {
            get => _inner.Value!;
            set => _inner.Value = value!;
        }

        public NotNullReactiveProperty([NotNull] IReactiveProperty<T> inner)
        {
            _inner = inner;
        }

        public IDisposable Subscribe(IObserver<T> observer)
        {
            return _inner.Subscribe(observer);
        }
    }
}