using System;
using System.Collections.Generic;
using System.Linq;

namespace Magify
{
    internal static class ImpressionUtils
    {
        internal static int GetImpressionsPerPeriod(IReadOnlyDictionary<string, List<DateTime>> impressionTimestamps, string key, TimeSpan period)
        {
            if (!impressionTimestamps.TryGetValue(key, out var timestamps))
            {
                return 0;
            }

            var currentTime = DateTime.UtcNow;
            return timestamps.Count(x => (currentTime - x) <= period);
        }
    }
}