using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal static class CampaignTypeExtensions
    {
        [CanBeNull]
        internal static string GetNestedCampaignType(this CampaignType type)
        {
            return type switch
            {
                CampaignType.RewardedVideo or CampaignType.LtoRewardedVideo => "nested_rewarded_video",
                CampaignType.Mixed or CampaignType.LtoMixed => "nested_mixed",
                _ => null
            };
        }

        internal static bool? IsSupportNested(this CampaignType campaignType)
        {
            switch (campaignType)
            {
                case CampaignType.Banner:
                case CampaignType.Interstitial:
                case CampaignType.CrossPromo:
                case CampaignType.LtoCrossPromo:
                case CampaignType.External:
                case CampaignType.LtoExternal:
                case CampaignType.Notification:
                case CampaignType.RateReview:
                    return false;

                case CampaignType.RewardedVideo:
                case CampaignType.LtoRewardedVideo:
                case CampaignType.Bonus:
                case CampaignType.LtoBonus:
                case CampaignType.InApp:
                case CampaignType.LtoInApp:
                case CampaignType.Subscription:
                case CampaignType.LtoSubscription:
                case CampaignType.Mixed:
                case CampaignType.LtoMixed:
                    return true;

                default:
                    return null;
            }
        }

        internal static bool? IsRequiredProductType(this CampaignType type, ProductType productType)
        {
            switch (type)
            {
                case CampaignType.Banner:
                case CampaignType.Interstitial:
                case CampaignType.CrossPromo:
                case CampaignType.LtoCrossPromo:
                case CampaignType.External:
                case CampaignType.LtoExternal:
                case CampaignType.Notification:
                case CampaignType.RateReview:
                    return false;

                case CampaignType.RewardedVideo:
                case CampaignType.LtoRewardedVideo:
                    return productType is ProductType.Rewarded;
                case CampaignType.Bonus:
                case CampaignType.LtoBonus:
                    return productType is ProductType.Bonus;
                case CampaignType.InApp:
                case CampaignType.LtoInApp:
                    return productType is ProductType.Consumable or ProductType.NonConsumable;
                case CampaignType.Subscription:
                case CampaignType.LtoSubscription:
                    return productType is ProductType.Subscription;
                case CampaignType.Mixed:
                case CampaignType.LtoMixed:
                    return true;

                default:
                    return null;
            }
        }

        internal static bool HasNestedAdsCampaigns(this CampaignType type)
        {
            return GetNestedCampaignType(type) != null;
        }

        internal static bool? IsLimitedOffer(this CampaignType campaignType)
        {
            switch (campaignType)
            {
                case CampaignType.Subscription:
                case CampaignType.Interstitial:
                case CampaignType.RateReview:
                case CampaignType.External:
                case CampaignType.CrossPromo:
                case CampaignType.Notification:
                case CampaignType.RewardedVideo:
                case CampaignType.Banner:
                case CampaignType.InApp:
                case CampaignType.Bonus:
                case CampaignType.Mixed:
                    return false;
                case CampaignType.LtoInApp:
                case CampaignType.LtoSubscription:
                case CampaignType.LtoExternal:
                case CampaignType.LtoCrossPromo:
                case CampaignType.LtoRewardedVideo:
                case CampaignType.LtoBonus:
                case CampaignType.LtoMixed:
                    return true;
                default:
                    return null;
            }
        }
    }
}