using System.Linq;
using Magify.Model;

namespace Magify
{
    public static class CampaignModelExtensions
    {
        internal static bool IsCampaignRelevant(this CampaignModel campaign, PlatformAPI platform)
        {
            return campaign.Type switch
            {
                CampaignType.CrossPromo or CampaignType.LtoCrossPromo => !platform.IsApplicationInstalled(campaign.Info?.Application),
                _ => true
            };
        }

        internal static bool TryGetNested(this CampaignModel campaign, string productId, out NestedCampaign result)
        {
            result = campaign.NestedCampaigns?.FirstOrDefault(p => p.ProductId == productId);
            return result != null;
        }
    }
}