using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    // ToDo: should try to optimize and avoid HashSet allocation where possible
    internal struct ReferrerLimits
    {
        [CanBeNull]
        public HashSet<string> IncludeIds { get; init; }

        [CanBeNull]
        public HashSet<string> ExcludeIds { get; init; }
    }

    internal static class ReferrerLimitsExtensions
    {
        internal static bool IsCorresponded(this ReferrerLimits referrerLimits, string referrerId)
        {
            var includeLimits = referrerLimits.IncludeIds?.Count is null or 0 || referrerLimits.IncludeIds.Contains(referrerId);
            var excludeLimits = referrerLimits.ExcludeIds?.Count is null or 0 || !referrerLimits.ExcludeIds.Contains(referrerId);

            return includeLimits && excludeLimits;
        }
    }
}