﻿using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal abstract class SplashScreenParser
    {
        public bool IsValid(SplashscreenModel model)
        {
            return true;
        }

        public abstract ISplashScreen Parse([NotNull] SplashscreenModel model);
    }

    internal abstract class SplashScreenParser<T> : SplashScreenParser
        where T : ISplashScreen
    {
        public sealed override ISplashScreen Parse(SplashscreenModel model)
        {
            return ParseSplashScreen(model);
        }

        protected abstract T ParseSplashScreen([NotNull] SplashscreenModel model);
    }

    internal class NoSplashScreenParser : SplashScreenParser<NoSplash>
    {
        protected override NoSplash ParseSplashScreen(SplashscreenModel model)
        {
            return new NoSplash
            {
                Attributes = model.Attributes,
                Timeout = model.Context?.Timeout?.TotalSeconds ?? 0
            };
        }
    }

    internal class LoaderSplashScreenParser : SplashScreenParser<LoaderSplash>
    {
        protected override LoaderSplash ParseSplashScreen(SplashscreenModel model)
        {
            return new LoaderSplash
            {
                Attributes = model.Attributes,
                MinTime = model.Context?.MinTime?.TotalSeconds ?? 0,
                MaxTime = model.Context?.MaxTime?.TotalSeconds ?? 0,
            };
        }
    }

    internal class PopupSplashScreenParser : SplashScreenParser<PopupSplash>
    {
        protected override PopupSplash ParseSplashScreen(SplashscreenModel model)
        {
            return new PopupSplash
            {
                Attributes = model.Attributes,
                Time = model.Context?.Time?.TotalSeconds ?? 0,
                Timeout = model.Context?.Timeout?.TotalSeconds ?? 0,
                MaxTime = model.Context?.MaxTime?.TotalSeconds ?? 0,
                IsForced = model.Context?.IsForced ?? false
            };
        }
    }
}