﻿using System.Linq;
using System.Runtime.Serialization;

namespace Magify
{
    internal enum CounterScope : ushort
    {
        [EnumMember(Value = "global")]
        Global = 0,

        [EnumMember(Value = "version")]
        Version = 1,

        [EnumMember(Value = "session")]
        Session = 2,

        [EnumMember(Value = "daily")]
        Daily = 3,

        [EnumMember(Value = "activation")]
        Activation = 4,

        [EnumMember(Value = "period")]
        Period = 5
    }

    internal enum BonusesCounterScope : ushort
    {
        Global = CounterScope.Global,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
    }

    internal enum ClicksCounterScope : ushort
    {
        Global = CounterScope.Global,
    }

    internal enum EventsCounterScope : ushort
    {
        Global = CounterScope.Global,
        Version = CounterScope.Version,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
    }

    internal enum ImpressionsCounterScope : ushort
    {
        Global = CounterScope.Global,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
        Period = CounterScope.Period,
        Activation = CounterScope.Activation
    }

    internal enum RewardsCounterScope : ushort
    {
        Global = CounterScope.Global,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
        Activation = CounterScope.Activation
    }

    internal enum NestedCounterScope : ushort
    {
        Global = CounterScope.Global,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
        Activation = CounterScope.Activation,
    }

    internal enum LtoStartCounterScope : ushort
    {
        Global = CounterScope.Global,
        Session = CounterScope.Session,
        Daily = CounterScope.Daily,
        Period = CounterScope.Period
    }

    internal static class CounterScopeExt
    {
        public static readonly CounterScope[] Scopes = EnumExtensions.GetValues<CounterScope>().ToArray();
        public static readonly string[] ScopesNames = EnumExtensions.GetValues<CounterScope>().Select(c => c.ToEnumString()).ToArray();

        public static string GetName(this CounterScope scope)
        {
            var index = (int)scope;
            return ScopesNames[index];
        }
    }
}