using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class CampaignRequest
    {
        [NotNull]
        public ICampaign Campaign { get; init; }

        public CampaignSource Source { get; init; }

        public bool IsDefaultCampaign { get; init; }

        [CanBeNull]
        public IReadOnlyList<NestedCampaign> NestedCampaigns { get; init; }

        [CanBeNull]
        public AbstractProductsCollection ParsedProducts { get; init; }

        [CanBeNull]
        public Dictionary<string, object> CustomParams { get; init; }
    }
}