﻿using JetBrains.Annotations;

namespace Magify
{
    internal static class EncodingModeUtils
    {
        internal const int EncodingModePrefixLength = 3; // Because byte.MaxValue is 255 (3 digits)

        [NotNull]
        public static string ToPrefixString(this EncodingMode encodingMode)
        {
            var byteStr = ((byte)encodingMode).ToString();
            return byteStr!.PadLeft(EncodingModePrefixLength, '0');
        }

        public static EncodingMode FromPrefixString(this EncodingMode _, [NotNull] string source)
        {
            var encodingModePrefix = source[..EncodingModePrefixLength]!;
            return (EncodingMode)byte.Parse(encodingModePrefix);
        }
    }
}