﻿using System;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;
using UnityEngine;

namespace Magify
{
    internal class DisabledAppStateManager : IAppStateManager
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.AppState);
        [CanBeNull]
        private readonly string _disablingReason;

        [NotNull]
        IObservable<SyncStateResult> IAppStateManager.OnRestoreStateCompleted
        {
            get
            {
                LogDisabled();
                return new Subject<SyncStateResult>();
            }
        }

        [NotNull]
        IReactiveProperty<AutoRestoreStateInfo> IAppStateManager.AutoRestoreStateInfo
        {
            get
            {
                LogDisabled();
                return new ReactiveProperty<AutoRestoreStateInfo>();
            }
        }

        [NotNull]
        IReactiveProperty<bool> IAppStateManager.IsAutoRestoreStateEnabled
        {
            get
            {
                LogDisabled();
                return new ReactiveProperty<bool>();
            }
        }

        bool IAppStateManager.HasSocialAuthorizationData
        {
            get
            {
                LogDisabled();
                return false;
            }
        }

        public DisabledAppStateManager([CanBeNull] string disablingReason)
        {
            _disablingReason = disablingReason;
        }

        UniTask<bool> IAppStateManager.RequestSocialAuthTokenFor([NotNull] string provider, [NotNull] string token, CancellationToken cancellationToken)
        {
            LogDisabled();
            return UniTask.FromResult(false);
        }

        void IAppStateManager.ResetSocialAuthToken()
        {
            LogDisabled();
        }

        UniTask<SyncStateResult> IAppStateManager.SaveState(int? weight, CancellationToken cancellationToken)
        {
            LogDisabled();
            return UniTask.FromResult(SyncStateResult.SyncIsDisabled());
        }

        public UniTask<SyncStateResult> RestoreState(int? weight, CancellationToken cancellationToken, bool forceSync = false)
        {
            LogDisabled();
            return UniTask.FromResult(SyncStateResult.SyncIsDisabled());
        }

        private void LogDisabled()
        {
            _logger.LogError($"Application state API is disabled. Reason: {_disablingReason}");
        }
    }
}