using System;
using Magify.Model;
using JetBrains.Annotations;

namespace Magify
{
    internal interface IAnalyticsTracker
    {
        IObservable<EventType> OnEventSent { get; }
        IObservable<(EventType Type, IAnalyticsEvent Event)> OnEventSentDetailed { get; }
        void HandeWentForeground();
        void HandeWentBackground();
        void TrackAppLaunch();
        void TrackAppBackgroundEvent(long openTime, long closeTime, string appVersion);
        void TrackUsedApplicationDefaultFeaturesEvent([NotNull] string featureName);
    }
}