using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class AnalyticsEventStorage<T>
    {
        public const string AnalyticsFolderName = "analytics";

        [NotNull]
        private readonly string _fileName;
        [NotNull]
        private readonly FileStorage _storage;

        public AnalyticsEventStorage(EventType eventType, string storagePath)
        {
            _fileName = $"{eventType}.json";
            _storage = new FileStorage(storagePath, AnalyticsFolderName);
        }

        public bool Exists()
        {
            return _storage.Exists(_fileName);
        }

        public List<T> LoadEvents()
        {
            return _storage.LoadJson<List<T>>(_fileName);
        }

        public void SaveEvents([NotNull] IReadOnlyCollection<T> events)
        {
            _storage.SaveJson(_fileName, events);
        }

        public void Clear()
        {
            _storage.Clear(_fileName);
        }
    }
}