using UnityEngine;

namespace Magify
{
    public abstract class LtoView<TContent> : LtoView
        where TContent : class
    {
        public ContentHandle<TContent> Content { get; set; }

        public override void ReleaseContent()
        {
            Content.Dispose();
        }
    }

    public abstract class LtoView : MonoBehaviour
    {
        public abstract void PrepareAsset();
        public abstract void Show();
        public abstract void ReleaseContent();
    }
}