using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    public class LtoTextureView : LtoView<Texture>
    {
        [SerializeField]
        protected RawImage _rawImage;
        [SerializeField]
        private AspectRatioFitter _aspectRatioFitter;

        public override void Show()
        {
            _rawImage.enabled = true;
            var artifact = _rawImage.texture;
            _aspectRatioFitter.aspectRatio = (float) artifact.width / artifact.height;
        }

        public override void PrepareAsset()
        {
            _rawImage.texture = Content.Value;
            _rawImage.enabled = false;
        }

        public override void ReleaseContent()
        {
            if (_rawImage != null)
            {
                _rawImage.texture = null;
                _rawImage.enabled = false;
            }

            base.ReleaseContent();
        }
    }
}