using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    internal class LtoRenderTextureView : LtoView
    {
        [SerializeField]
        protected RawImage _rawImage;
        [SerializeField]
        private AspectRatioFitter _aspectRatioFitter;

        public BundledCreative Content { get; internal set; }

        public override void Show()
        {
            var artifact = _rawImage.texture;
            _rawImage.enabled = true;
            _aspectRatioFitter.aspectRatio = (float)artifact.width / artifact.height;
        }

        public override void PrepareAsset()
        {
            Content.Initialize();
            _rawImage.texture = Content.RenderTexture;
            _rawImage.enabled = false;
        }

        public override void ReleaseContent()
        {
            if (_rawImage != null)
            {
                _rawImage.texture = null;
                _rawImage.enabled = false;
            }
        }
    }
}