using UnityEngine;

namespace Magify
{
    internal class LtoPrefabView : LtoView
    {
        [SerializeField] private RectTransform _parent;

        public BundledPrefab Content { get; set; }

        public override void PrepareAsset()
        {
            var prefabTransform = Content.GetComponent<RectTransform>();
            prefabTransform.SetParent(_parent, false);
            prefabTransform.anchorMin = Vector2.zero;
            prefabTransform.anchorMax = Vector2.one;
            prefabTransform.anchoredPosition = Vector2.zero;
            prefabTransform.sizeDelta = Vector2.zero;
            prefabTransform.localScale = Vector3.one;
            Content.gameObject.SetActive(false);
        }

        public override void Show()
        {
            Content.gameObject.SetActive(true);
        }

        public override void ReleaseContent()
        {
        }
    }
}