using UnityEngine;

namespace Magify
{
    public class LtoBundleView : LtoView<AssetBundle>
    {
        [SerializeField]
        private LtoRenderTextureView _ltoRenderTextureView;
        [SerializeField]
        private LtoPrefabView _ltoPrefabView;

        private static readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.Lto);
        private GameObject _instance;
        private LtoView _currentView;

        public override void PrepareAsset()
        {
            _instance = Instantiate(Content.Value.GetMainGameObject(), MagifyManager.Presenter.transform.parent);

            if (_instance.TryGetComponent<BundledCreative>(out var bundledCreative))
            {
                _currentView = _ltoRenderTextureView;
                _ltoRenderTextureView.Content = bundledCreative;
            }
            else if (_instance.TryGetComponent<BundledPrefab>(out var bundledPrefab))
            {
                _currentView = _ltoPrefabView;
                _ltoPrefabView.Content = bundledPrefab;
            }
            else
            {
                _logger.LogError("Content isn't suitable for display as lto");
            }

            _currentView.PrepareAsset();
        }

        public override void Show()
        {
            _currentView.gameObject.SetActive(true);
            _currentView.Show();
        }

        public override void ReleaseContent()
        {
            _currentView.ReleaseContent();
            if (_instance != null)
            {
                Destroy(_instance.gameObject);
                _instance = null;
            }
            base.ReleaseContent();
        }
    }
}