using JetBrains.Annotations;
using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    public class MagifyPresenter : MonoBehaviour
    {
        public Canvas Canvas { get; private set; }
        public CanvasScaler Scaler { get; private set; }
        public GraphicRaycaster Raycaster { get; private set; }
        internal CanvasSafeArea SafeArea { get; private set; }

        internal static MagifyPresenter BuildDefaultPresenter([CanBeNull] IPresenterSettings settings, Transform root)
        {
            var obj = new GameObject("MagifyPresenter", typeof(Canvas), typeof(GraphicRaycaster), typeof(CanvasScaler), typeof(MagifyPresenter), typeof(CanvasSafeArea));
            obj.transform.SetParent(root);

            var com = obj.GetComponent<MagifyPresenter>();
            com.gameObject.name = nameof(MagifyPresenter);

            com.Canvas = com.GetComponent<Canvas>();
            com.Canvas.renderMode = settings?.RenderMode ?? RenderMode.ScreenSpaceOverlay;
            com.Canvas.sortingOrder = settings?.SortingOrder ?? short.MaxValue;

            com.Scaler = com.GetComponent<CanvasScaler>();
            com.Scaler.uiScaleMode = settings?.UiScaleMode ?? CanvasScaler.ScaleMode.ScaleWithScreenSize;
            com.Scaler.referenceResolution = settings?.ReferenceResolution ?? new Vector2Int(1080, 1920);
            com.Scaler.matchWidthOrHeight = settings?.MatchWidthOrHeight ?? 0f;
            com.Scaler.referencePixelsPerUnit = settings?.ReferencePixelsPerUnit ?? 100;

            com.Raycaster = com.GetComponent<GraphicRaycaster>();
            com.SafeArea = com.GetComponent<CanvasSafeArea>();

            return com;
        }

        public void RecalculateSafeArea()
        {
            SafeArea.RecalculateAll();
        }
    }

    public interface IPresenterSettings
    {
        RenderMode RenderMode { get; set; }
        int SortingOrder { get; set; }
        CanvasScaler.ScaleMode UiScaleMode { get; set; }
        Vector2Int ReferenceResolution { get; set; }
        float MatchWidthOrHeight { get; set; }
        float ReferencePixelsPerUnit { get; set; }
    }
}