﻿using System;
using System.Collections.Generic;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    public partial class MagifyManager
    {
        public static class Aghanim
        {
            // ReSharper disable once MemberHidesStaticFromOuterClass
            public static IReactiveProperty<float> VerificationRetryInterval
            {
                get
                {
                    ThrowIfMagifyIsNotReady(nameof(VerificationRetryInterval));
                    return MagifyPlatformAPI!.Aghanim.VerificationRetryInterval;
                }
            }

            [NotNull]
            public static IObservable<(string OrderId, AghanimOrderStatus Status)> OnOrderStatusChanged
            {
                get
                {
                    ThrowIfMagifyIsNotReady(nameof(OnOrderStatusChanged));
                    return MagifyPlatformAPI!.Aghanim.OnOrderStatusChanged;
                }
            }

            public static UniTask<AghanimOrder> IssueOrder([NotNull] string productId, bool isSandbox, CancellationToken cancellationToken)
            {
                ThrowIfMagifyIsNotReady(nameof(IssueOrder));
                return MagifyPlatformAPI!.Aghanim.IssueOrder(productId, isSandbox, cancellationToken);
            }

            [NotNull]
            public static IEnumerable<AghanimOrderInfo> IterateAllOrders()
            {
                ThrowIfMagifyIsNotReady(nameof(IterateAllOrders));
                return MagifyPlatformAPI!.Aghanim.IterateAllOrders();
            }

            public static UniTask<IReadOnlyList<AghanimProductCounting>> LoadPurchasedProductsAsync(CancellationToken cancellationToken)
            {
                ThrowIfMagifyIsNotReady(nameof(LoadPurchasedProductsAsync));
                return MagifyPlatformAPI!.Aghanim.LoadPurchasedProductsAsync(cancellationToken);
            }

            [ContractAnnotation("=> true, productId:notnull; => false, productId:null")]
            public static bool TryGetProductOfOrder([NotNull] string orderId, [CanBeNull] out string productId)
            {
                ThrowIfMagifyIsNotReady(nameof(TryGetProductOfOrder));
                return MagifyPlatformAPI!.Aghanim.TryGetProductOfOrder(orderId, out productId);
            }

            public static bool TryGetOrderInfo([NotNull] string orderId, out AghanimOrderInfo info)
            {
                ThrowIfMagifyIsNotReady(nameof(TryGetOrderInfo));
                return MagifyPlatformAPI!.Aghanim.TryGetOrderInfo(orderId, out info);
            }

            public static bool TryGetOrderWithStatus([NotNull] string orderId, out AghanimOrderStatus status)
            {
                ThrowIfMagifyIsNotReady(nameof(TryGetOrderWithStatus));
                return MagifyPlatformAPI!.Aghanim.TryGetOrderWithStatus(orderId, out status);
            }

            public static UniTask<AghanimOrderStatus> WaitForFinalOrderStatusAsync([NotNull] string orderId, CancellationToken cancellationToken)
            {
                ThrowIfMagifyIsNotReady(nameof(WaitForFinalOrderStatusAsync));
                return MagifyPlatformAPI!.Aghanim.WaitForFinalOrderStatusAsync(orderId, cancellationToken);
            }
        }
    }
}