﻿using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace Magify
{
    [StructLayout(LayoutKind.Sequential)]
    internal struct InterScreen
    {
        public SplashscreenType Type;
        public double MinTime;
        public double MaxTime;
        public double ExactTime;
        public double Timeout;
        public bool IsForced;
        public Dictionary<string, object> Attributes;

        public ISplashScreen ToSplashScreen()
        {
            return Type switch
            {
                SplashscreenType.No => new NoSplash
                {
                    Attributes = Attributes,
                    Timeout = Timeout
                },
                SplashscreenType.LoaderSplash => new LoaderSplash
                {
                    Attributes = Attributes,
                    MinTime = MinTime,
                    MaxTime = MaxTime
                },
                SplashscreenType.Popup => new PopupSplash
                {
                    Attributes = Attributes,
                    Time = ExactTime,
                    Timeout = Timeout,
                    MaxTime = MaxTime,
                    IsForced = IsForced
                },
                _ => null
            };
        }
    }
}