﻿using System.Collections.Generic;
using UnityEngine;

namespace Magify
{
    internal class CampaignScreen
    {
        public bool IsFullScreen => Opacity >= 100f;

        public ScreenType Type { get; init; }
        public string ScreenId { get; init; }
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string PortraitUrl { get; init; }
        public string LandscapeUrl { get; init; }
        public float ButtonCloseTimeout { get; init; }
        public Color Color { get; init; }
        public float Opacity { get; init; }
        public bool BlurBackground { get; init; }

        public override string ToString()
        {
            return $"{nameof(Type)}={Type}; {nameof(ScreenId)}={ScreenId}; {nameof(Opacity)}={Opacity}; {nameof(BlurBackground)}={BlurBackground}";
        }

        public ICreative ToCreative()
        {
            switch (Type)
            {
                case ScreenType.NoUI:
                    return new NoUiCreative { Attributes = Attributes };
                case ScreenType.Custom:
                    return new CustomCreative
                    {
                        Attributes = Attributes,
                        ScreenId = ScreenId
                    };
                case ScreenType.Image:
                    return new ImageCreative
                    {
                        Attributes = Attributes,
                        Portrait = PortraitUrl,
                        Landscape = LandscapeUrl,
                        ButtonCloseTimeout = ButtonCloseTimeout,
                        Background = new CreativeBackground
                        {
                            Color = Color,
                            Opacity = (int)Opacity,
                            IsBlurred = BlurBackground,
                        }
                    };
                case ScreenType.Bundle:
                    return new BundleCreative
                    {
                        Attributes = Attributes,
                        Url = PortraitUrl,
                        ButtonCloseTimeout = ButtonCloseTimeout,
                        Background = new CreativeBackground
                        {
                            Color = Color,
                            Opacity = (int)Opacity,
                            IsBlurred = BlurBackground,
                        }
                    };
            }

            // Convert unsupported screens to NoUI
            return null;
        }
    }
}