using System;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Object = UnityEngine.Object;

namespace Magify
{
    [Serializable]
    public struct UniversalElement
    {
        public string Id;
        public Object Element;
    }

    public class UniversalElementsContainer : MonoBehaviour
    {
        [SerializeField]
        private List<UniversalElement> _elements;

        public IEnumerable<(string Id, Object Element)> GetElements(Func<string, Object, bool> predicate)
        {
            return _elements.Where(element => predicate(element.Id, element.Element)).Select(element => (element.Id, element.Element));
        }

        public bool TryGetElement<T>(string id, out T element) where T : Object
        {
            element = _elements.FirstOrDefault(t => t.Id == id).Element as T;
            return element != null;
        }
    }
}