using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

namespace Magify
{
    public class BundledCreative : MonoBehaviour
    {
        public static int BundlesLayer { get; set; } = 30;
        public static Vector3 CreativeOffset { get; set; } = new Vector3(500, 500, 0);
        public static Vector3 CreativeStep { get; set; } = new Vector3(20, 0, 0);
        public static int CreativeCounter { get; private set; }

        public Camera Camera { get; private set; }
        public Transform Transform { get; private set; }
        public IReadOnlyList<BaseRaycaster> Raycasters { get; private set; }
        public RenderTexture RenderTexture => Camera != null ? Camera.targetTexture : null;

        public void Initialize()
        {
            SetupCamera();
            SetupRaycasters();

            // cache variables
            Transform = transform;
            Transform.position = CreativeOffset + CreativeStep * CreativeCounter++;
            gameObject.SetActive(true);
        }

        private void SetupCamera()
        {
            Camera = GetComponentInChildren<Camera>();
            var layer = Mathf.Clamp(BundlesLayer, 0, 30);
            Camera.cullingMask = 1 << layer;
            Camera.farClipPlane = 150;

            gameObject.layer = layer;
            foreach (var child in gameObject.GetComponentsInChildren<Transform>())
            {
                child.gameObject.layer = layer;
            }
        }

        private void SetupRaycasters()
        {
            Raycasters = GetComponentsInChildren<BaseRaycaster>();

            // disable raycasters
            foreach (var raycaster in Raycasters)
            {
                raycaster.enabled = false;
            }
        }
    }
}