using System;
using System.Collections.Generic;

namespace Magify
{
    public class LtoBadgeCreative
    {
        /// <summary>
        /// Lto unique identifier
        /// </summary>
        public string Tag { get; init; }

        /// <summary>
        /// Custom badge text, already localised
        /// </summary>
        public string Title { get; init; }

        public string LabelText { get; init; }

        public CreativeResource Resource { get; init; }

        /// <summary>
        /// link to default image?
        /// </summary>
        public string Placeholder { get; init; }

        /// <summary>
        /// show hide badge
        /// </summary>
        public bool HasTimer { get; init; }

        /// <summary>
        /// Remaining time for badge in minutes
        /// </summary>
        public int LastMinutesTimer { get; init; }

        public Dictionary<string, object> Attributes { get; init; }

        public bool Equals(LtoBadgeCreative other)
        {
            return Tag == other.Tag &&
                   Title == other.Title &&
                   LabelText == other.LabelText &&
                   Resource.Equals(other.Resource) &&
                   Placeholder == other.Placeholder &&
                   HasTimer == other.HasTimer &&
                   LastMinutesTimer == other.LastMinutesTimer &&
                   (Attributes == other.Attributes || Attributes.Compare(other.Attributes));
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj is not LtoBadgeCreative other) return false;
            return Equals(other);
        }

        public override int GetHashCode()
        {
            return HashCode.Combine(Tag, Title, LabelText, Resource, Placeholder, HasTimer, LastMinutesTimer, Attributes);
        }
    }
}