using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class IronSourceAdsImpression : IAdsImpression
    {
        [JsonProperty("Mediation"), Preserve]
        public AdsMediation Mediation => AdsMediation.IronSource;

        [JsonProperty("UnitId"), Preserve]
        public string Id { get; set; }

        [JsonProperty("Network"), Preserve]
        public string Network { get; set; }

        [JsonProperty("AdUnit"), Preserve]
        public string AdUnit { get; set; }

        [JsonProperty("InstanceName"), Preserve]
        public string InstanceName { get; set; }

        [JsonProperty("Revenue"), Preserve]
        public double? Revenue { get; set; }

        [JsonProperty("Precision"), Preserve]
        public string Precision { get; set; }

        [JsonProperty("Ab"), Preserve]
        public string Ab { get; set; }

        [JsonProperty("AuctionId"), Preserve]
        public string AuctionId { get; set; }

        [JsonProperty("SegmentName"), Preserve]
        public string SegmentName { get; set; }

        [JsonProperty("LifetimeRevenue"), Preserve]
        public double? LifetimeRevenue { get; set; }

        [JsonProperty("EncryptedCPM"), Preserve]
        public string EncryptedCpm { get; set; }
    }
}