﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    [Flags]
    public enum FeatureSource : byte
    {
        None = 0,
        Default = 1 << 0,
        Current = 1 << 1,
    }

    internal interface IFeatures
    {
        public event Action<ConfigKind> OnUpdate;
        bool IsCurrentFeaturesParsed { get; }

        public bool TryGetBool(string featureName, out Feature<bool> result);
        public Feature<bool> GetBool(string featureName);

        public bool TryGetNumber(string featureName, out Feature<double> result);
        public Feature<double> GetNumber(string featureName);

        public bool TryGetString(string featureName, out Feature<string> result);
        public Feature<string> GetString(string featureName);
        public void SetIgnoredFeatures([CanBeNull] IEnumerable<string> features, FeatureSource source);
    }
}