using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class ApplovinAdsImpression : IAdsImpression
    {
        [JsonProperty("Mediation"), Preserve]
        public AdsMediation Mediation => AdsMediation.Applovin;

        [JsonProperty("UnitId"), Preserve]
        public string Id { get; set; }

        [JsonProperty("Network"), Preserve]
        public string Network { get; set; }

        [JsonProperty("ImpressionId"), Preserve]
        public string ImpressionId { get; set; }

        [JsonProperty("Revenue"), Preserve]
        public double? Revenue { get; set; }

        [JsonProperty("Precision"), Preserve]
        public string Precision { get; set; }
    }
}