﻿using System;
using JetBrains.Annotations;

namespace Magify.Rx
{
    // Optimize for .Where().Select()
    internal class WhereSelectObservable<T, TR> : OperatorObservableBase<TR>
    {
        [NotNull]
        private readonly IObservable<T> _source;
        [NotNull]
        private readonly Func<T, bool> _predicate;
        [NotNull]
        private readonly Func<T, TR> _selector;

        public WhereSelectObservable([NotNull] IObservable<T> source, [NotNull] Func<T, bool> predicate, [NotNull] Func<T, TR> selector)
        {
            _source = source;
            _predicate = predicate;
            _selector = selector;
        }

        protected override IDisposable SubscribeCore([NotNull] IObserver<TR> observer, [NotNull] IDisposable cancel)
        {
            return _source.Subscribe(new WhereSelect(this, observer, cancel));
        }

        private class WhereSelect : OperatorObserverBase<T, TR>
        {
            [NotNull]
            private readonly WhereSelectObservable<T, TR> _parent;

            public WhereSelect([NotNull] WhereSelectObservable<T, TR> parent, [NotNull] IObserver<TR> observer, [NotNull] IDisposable cancel) : base(observer, cancel)
            {
                _parent = parent;
            }

            public override void OnNext(T value)
            {
                bool isPassed;
                try
                {
                    isPassed = _parent._predicate(value);
                }
                catch (Exception ex)
                {
                    try { Observer.OnError(ex); } finally { Dispose(); }
                    return;
                }

                if (isPassed)
                {
                    TR v;
                    try
                    {
                        v = _parent._selector(value);
                    }
                    catch (Exception ex)
                    {
                        try { Observer.OnError(ex); } finally { Dispose(); }
                        return;
                    }

                    Observer.OnNext(v);
                }
            }

            public override void OnError([NotNull] Exception error)
            {
                try { Observer.OnError(error); } finally { Dispose(); }
            }

            public override void OnCompleted()
            {
                try { Observer.OnCompleted(); } finally { Dispose(); }
            }
        }
    }
}