using System;
using System.Threading;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal abstract class OperatorObserverBase<TSource, TResult> : IDisposable, IObserver<TSource>
    {
        [NotNull]
        protected volatile IObserver<TResult> Observer;
        [NotNull]
        private IDisposable _cancel;

        protected OperatorObserverBase([NotNull] IObserver<TResult> observer, [NotNull] IDisposable cancel)
        {
            Observer = observer;
            _cancel = cancel;
        }

        public abstract void OnNext(TSource value);

        public abstract void OnError(Exception error);

        public abstract void OnCompleted();

        public void Dispose()
        {
            Observer = EmptyObserver<TResult>.Instance;
            var target = Interlocked.Exchange(ref _cancel, null);
            target?.Dispose();
        }
    }
}