using System;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal class FromEventObservable<T> : OperatorObservableBase<T>
    {
        [NotNull]
        private readonly Action<Action<T>> _addHandler;
        [NotNull]
        private readonly Action<Action<T>> _removeHandler;

        public FromEventObservable([NotNull] Action<Action<T>> addHandler, [NotNull] Action<Action<T>> removeHandler)
        {
            _addHandler = addHandler;
            _removeHandler = removeHandler;
        }

        protected override IDisposable SubscribeCore(IObserver<T> observer, IDisposable cancel)
        {
            var fromEvent = new FromEvent(this, observer);
            return fromEvent.Register() ?  fromEvent : EmptyDisposable.Singleton;
        }

        private class FromEvent : IDisposable
        {
            [NotNull]
            private readonly FromEventObservable<T> _parent;
            [NotNull]
            private readonly IObserver<T> _observer;
            private Action<T> _handler;

            public FromEvent([NotNull] FromEventObservable<T> parent, [NotNull] IObserver<T> observer)
            {
                _parent = parent;
                _observer = observer;
                _handler = OnNext;
            }

            public bool Register()
            {
                try
                {
                    _parent._addHandler(_handler);
                }
                catch (Exception ex)
                {
                    _observer.OnError(ex);
                    return false;
                }
                return true;
            }

            void OnNext(T value)
            {
                _observer.OnNext(value);
            }

            public void Dispose()
            {
                if (_handler != null)
                {
                    _parent._removeHandler(_handler);
                    _handler = null;
                }
            }
        }
    }

    internal class FromEventObservableVoid : OperatorObservableBase<Unit>
    {
        [NotNull]
        private readonly Action<Action> _addHandler;
        [NotNull]
        private readonly Action<Action> _removeHandler;

        public FromEventObservableVoid([NotNull] Action<Action> addHandler, [NotNull] Action<Action> removeHandler)
        {
            _addHandler = addHandler;
            _removeHandler = removeHandler;
        }

        protected override IDisposable SubscribeCore(IObserver<Unit> observer, IDisposable cancel)
        {
            var fromEvent = new FromEvent(this, observer);
            return fromEvent.Register() ?  fromEvent : EmptyDisposable.Singleton;
        }

        private class FromEvent : IDisposable
        {
            [NotNull]
            private readonly FromEventObservableVoid _parent;
            [NotNull]
            private readonly IObserver<Unit> _observer;
            private Action _handler;

            public FromEvent([NotNull] FromEventObservableVoid parent, [NotNull] IObserver<Unit> observer)
            {
                _parent = parent;
                _observer = observer;
                _handler = OnNext;
            }

            public bool Register()
            {
                try
                {
                    _parent._addHandler(_handler);
                }
                catch (Exception ex)
                {
                    _observer.OnError(ex);
                    return false;
                }
                return true;
            }

            void OnNext()
            {
                _observer.OnNext(Unit.Default);
            }

            public void Dispose()
            {
                if (_handler != null)
                {
                    _parent._removeHandler(_handler);
                    _handler = null;
                }
            }
        }
    }
}