﻿using System;
using System.Threading;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal sealed class ObserverNode<T> : IObserver<T>, IDisposable
    {
        [NotNull]
        private readonly IObserver<T> _observer;
        [NotNull]
        private IObserverLinkedList<T> _list;

        public ObserverNode<T> Previous { get; internal set; }
        public ObserverNode<T> Next { get; internal set; }

        public ObserverNode([NotNull] IObserverLinkedList<T> list, [NotNull] IObserver<T> observer)
        {
            _list = list;
            _observer = observer;
        }

        public void OnNext(T value)
        {
            _observer.OnNext(value);
        }

        public void OnError(Exception error)
        {
            _observer.OnError(error);
        }

        public void OnCompleted()
        {
            _observer.OnCompleted();
        }

        public void Dispose()
        {
            var sourceList = Interlocked.Exchange(ref _list, null);
            sourceList?.UnsubscribeNode(this);
        }
    }
}