﻿using System;
using System.Threading;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal static class Observer
    {
        internal static IObserver<T> CreateSubscribeObserver<T>([NotNull] Action<T> onNext, [NotNull] Action<Exception> onError, [NotNull] Action onCompleted)
        {
            // need compare for avoid iOS AOT
            if (onNext == Stubs<T>.Ignore)
            {
                return new Subscribe_<T>(onError, onCompleted);
            }
            else
            {
                return new Subscribe<T>(onNext, onError, onCompleted);
            }
        }

        private class Subscribe<T> : IObserver<T>
        {
            [NotNull]
            private readonly Action<T> _onNext;
            [NotNull]
            private readonly Action<Exception> _onError;
            [NotNull]
            private readonly Action _onCompleted;

            private int _isStopped;

            public Subscribe([NotNull] Action<T> onNext, [NotNull] Action<Exception> onError, [NotNull] Action onCompleted)
            {
                _onNext = onNext;
                _onError = onError;
                _onCompleted = onCompleted;
            }

            public void OnNext(T value)
            {
                if (_isStopped == 0)
                {
                    _onNext(value);
                }
            }

            public void OnError(Exception error)
            {
                if (Interlocked.Increment(ref _isStopped) == 1)
                {
                    _onError(error);
                }
            }


            public void OnCompleted()
            {
                if (Interlocked.Increment(ref _isStopped) == 1)
                {
                    _onCompleted();
                }
            }
        }

        // same as EmptyOnNextAnonymousObserver...
        // ReSharper disable once InconsistentNaming
        private class Subscribe_<T> : IObserver<T>
        {
            [NotNull]
            private readonly Action<Exception> _onError;
            [NotNull]
            private readonly Action _onCompleted;

            private int _isStopped;

            public Subscribe_([NotNull] Action<Exception> onError, [NotNull] Action onCompleted)
            {
                _onError = onError;
                _onCompleted = onCompleted;
            }

            public void OnNext(T value)
            {
            }

            public void OnError(Exception error)
            {
                if (Interlocked.Increment(ref _isStopped) == 1)
                {
                    _onError(error);
                }
            }

            public void OnCompleted()
            {
                if (Interlocked.Increment(ref _isStopped) == 1)
                {
                    _onCompleted();
                }
            }
        }
    }

    internal static class Stubs
    {
        [NotNull]
        public static readonly Action Nop = () => { };
        [NotNull]
        public static readonly Action<Exception> Throw = ex => throw ex;
    }

    internal static class Stubs<T>
    {
        [NotNull]
        public static readonly Action<T> Ignore = _ => { };
    }
}