﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal static class DisposableExtensions
    {
        /// <summary>Add disposable(self) to CompositeDisposable(or other ICollection). Return value is self disposable.</summary>
        [ContractAnnotation("disposable:notnull => notnull; disposable:null => null")]
        public static T AddTo<T>([NotNull] this T disposable, [NotNull] ICollection<IDisposable> container)
            where T : IDisposable
        {
            container.Add(disposable);
            return disposable;
        }
    }
}