using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class RewardProduct : ProductDef
    {
        public int Count { get; }

        public RewardProduct([NotNull] string productId, int count, [CanBeNull] ProductCreative creative = null, [CanBeNull] IReadOnlyDictionary<string, object> context = null, [CanBeNull] IReadOnlyList<PayoutDef> payouts = null)
            : base(productId, creative, context, payouts)
        {
            Count = count;
        }
    }
}