﻿using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify
{
    public abstract class ProductDef
    {
        internal const string FakeProductId = "<<fake.internal.product>>";

        [NotNull]
        public string Id { get; }

        [NotNull]
        public IReadOnlyList<PayoutDef> Payout { get; }

        [CanBeNull]
        public ProductCreative Creative { get; }

        [CanBeNull]
        public IReadOnlyDictionary<string, object> Context { get; }

        protected ProductDef([NotNull] string id, [CanBeNull] ProductCreative creative = null, [CanBeNull] IReadOnlyDictionary<string, object> context = null, [CanBeNull] IReadOnlyList<PayoutDef> payouts = null)
        {
            Id = id;
            Creative = creative;
            Context = context;
            Payout = payouts ?? ParseProductPayouts();
        }

        private List<PayoutDef> ParseProductPayouts()
        {
            var payoutDefs = new List<PayoutDef>();
            if (Context != null && Context.TryGetValue<List<object>>("items", out var items))
            {
                foreach (var itemRaw in items.OfType<Dictionary<string, object>>())
                {
                    var payoutType = itemRaw.TryGetValue("bonus", out var typeRaw) && typeRaw is string bonusType ? bonusType : null;
                    if (payoutType == null)
                    {
                        continue;
                    }
                    var payoutAmount = itemRaw.GetDouble("count");
                    var payout = new PayoutDef(payoutType, (float)payoutAmount, itemRaw);
                    payoutDefs.Add(payout);
                }
            }
            return payoutDefs;
        }

        public string ToJson(Formatting formatting = Formatting.None)
        {
            return JsonFacade.SerializeObject(this, formatting);
        }
    }
}