using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class InternalLinkProduct : ProductDef
    {
        [NotNull]
        public string Link { get; }

        public InternalLinkProduct([NotNull] string productId, [NotNull] string link, [CanBeNull] ProductCreative creative = null, [CanBeNull] IReadOnlyDictionary<string, object> context = null, [CanBeNull] IReadOnlyList<PayoutDef> payouts = null)
            : base(productId, creative, context, payouts)
        {
            Link = link;
        }
    }
}