using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class ExternalLinkProduct : ProductDef
    {
        [NotNull]
        public string Url { get; }

        public ExternalLinkProduct(
            [NotNull] string productId,
            [NotNull] string url,
            [CanBeNull] ProductCreative creative = null,
            [CanBeNull] IReadOnlyDictionary<string, object> context = null,
            [CanBeNull] IReadOnlyList<PayoutDef> payouts = null) : base(productId, creative, context, payouts)
        {
            Url = url;
        }
    }
}