using System.IO;
using System.Runtime.CompilerServices;
using JetBrains.Annotations;
using UnityEngine;

[assembly: InternalsVisibleTo("Magify")]
[assembly: InternalsVisibleTo("Magify.Core")]
[assembly: InternalsVisibleTo("Magify.CSharp")]
[assembly: InternalsVisibleTo("Magify.Model")]
[assembly: InternalsVisibleTo("Magify.Service")]
[assembly: InternalsVisibleTo("Magify.Editor")]
[assembly: InternalsVisibleTo("Magify.Tests.Editor")]
[assembly: InternalsVisibleTo("Magify.Tests.Runtime")]
[assembly: InternalsVisibleTo("Magify.CSharpTests")]
[assembly: InternalsVisibleTo("Magify.Tests.Rx")]
[assembly: InternalsVisibleTo("Magify.Sample")]
[assembly: InternalsVisibleTo("Magify.Sample.NativeCSharp")]
[assembly: InternalsVisibleTo("Magify.Sample.Editor")]
[assembly: InternalsVisibleTo("Magify.Editor.Tests")]
[assembly: InternalsVisibleTo("Magify.BundleCreator.Editor")]
[assembly: InternalsVisibleTo("DynamicProxyGenAssembly2")]

namespace Magify
{
    public static class PackageInfo
    {
        public const string Name = "com.magify.unity-sdk";
        public const string Version = "4.6.2";
        public const string DisplayName = "Magify";
        public const string ResourcesFolder = DisplayName;
        public const string RootMenuItem = DisplayName + "/";
        public const string FolderName = "com.campaigns.unity-sdk";
        [NotNull]
        public static string PersistentPath => Path.Combine(Application.persistentDataPath, FolderName);

        public const string DefaultCreativesConfig = "MagifyCreatives.json";
        public const string RootDefaultCreatives = "Magify";
    }
}