using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using System.Threading;
using Cysharp.Threading.Tasks;
using Magify.Rx;

namespace Magify
{
    internal interface ILegacyBridgePlatformAPI
    {
        event Action<LtoInfo> OnLtoDidFinish;
        event Action<IReadOnlyCollection<LtoInfo>> OnLtoDidUpdate;
    }

    internal interface IModernBridgePlatformAPI
    {
        event Action<LtoInfo> OnOfferAdded;
        event Action<LtoInfo> OnOfferUpdated;
        event Action<LtoInfo> OnOfferRemoved;
        event Action<LtoInfo> OnOfferFinished;
    }

    internal abstract class MagifyPlatformAPI : IDisposable
    {
        internal abstract void CompleteOffer(string offerName);
        [NotNull]
        internal abstract IReadOnlyCollection<LtoInfo> ActiveLtoOffers { get; }

        internal abstract event Action<ConfigKind> OnConfigParsed;
        internal abstract event Action<ConfigKind> OnConfigParsedOnMainThread;
        internal abstract event Action OnConfigLoaded;

        internal abstract Environment Environment { get; set; }
        [NotNull]
        internal abstract IReactiveProperty<IPurchaseVerificationHandler> ExternalPurchaseVerificationHandler { get; }
        [NotNull]
        internal abstract IReactiveProperty<float> VerificationRetryInterval { get; }
        internal abstract SubscriptionStatus SubscriptionStatus { get; set; }
        internal abstract bool IsLoggingEnabled { get; set; }
        [CanBeNull]
        internal abstract string ReferrerId { get; set; }
        [CanBeNull]
        internal abstract string AdjustId { get; set; }
        [CanBeNull]
        internal abstract string FirebaseInstanceId { get; set; }
        internal abstract bool IsPortrait { get; }
        internal abstract InAppStatus InAppStatus { get; set; }

        [CanBeNull]
        internal abstract ContextSyncTime LastContextSyncTime { get; }

        [NotNull]
        internal abstract IAghanimApi Aghanim { get; }

        /// <remarks>
        /// During a Reset instance of the Features might be changed.
        /// </remarks>
        [NotNull]
        internal abstract IFeatures Features { get; }

        internal abstract Limits Limits { get; }
        [NotNull]
        internal abstract string ClientId { get; }
        internal abstract bool CustomClientIdWasSet { get; }
        [NotNull]
        internal abstract IReactiveProperty<TimeSpan> SessionsInterval { get; }
        internal abstract int SessionNumber { get; }
        [NotNull]
        internal abstract string FirstInstalledVersion { get; }
        internal abstract DateTime FirstLaunchDate { get; }
        [NotNull]
        internal abstract IReactiveProperty<ConfigScope> RemoteContextScope { get; }
        internal abstract event Action<int> OnSessionChanged;
        internal abstract event Action OnSubscriptionStatusChanged;
        internal abstract event Action OnInAppStatusChanged;
        internal abstract event Action OnAuthorizationStatusChanged;
        internal abstract event Action OnReferrerChanged;
        internal abstract event Action OnPurchasedProductsChanged;
        internal abstract event Action OnApplicationEnterForeground;
        internal abstract event Action OnApplicationEnterBackground;
        internal abstract event Action OnUserDidTakeScreenshot;
        internal abstract AuthorizationStatus AuthorizationStatus { get; set; }
        [NotNull]
        internal abstract IReadOnlyList<InAppProduct> InAppProducts { get; }
        [NotNull]
        internal abstract IReadOnlyList<SubscriptionProduct> SubscriptionProducts { get; }
        [NotNull]
        internal abstract IReactiveProperty<bool> SyncStateEnabled { get; }
        [NotNull]
        internal abstract IUniTaskSource<bool> ClientIdFromCloudLoadingPromise { get; }
        [NotNull]
        internal abstract IObservable<SyncStateResult> OnRestoreStateCompleted { get; }
        [NotNull]
        internal abstract IReadOnlyReactiveProperty<AutoRestoreStateInfo> AutoRestoreStateInfo { get; }
        [NotNull]
        internal abstract IReactiveProperty<bool> IsAutoRestoreStateEnabled { get; }
        [NotNull]
        public abstract IReadOnlyReactiveProperty<long> LastSuccessfulSyncProgressUnixTimeSeconds { get; }
        public abstract bool ShouldSendLastSyncProgressTime { get; set; }
        internal abstract bool HasSocialAuthorizationData { get; }
        internal abstract bool SkipClientIdFromCloudLoading { get; set; }
        internal abstract uint ClientIdFromCloudLoadingSecondsTimeout { get; set; }
        internal abstract bool IsSdkInitialized { get; }
        [NotNull]
        internal abstract IReadOnlyReactiveProperty<IReadOnlyList<string>> Segmentations { get; }
        [NotNull]
        internal abstract IReadOnlyReactiveProperty<IReadOnlyList<AssignedAbTest>> AssignedAbTests { get; }
        [NotNull]
        internal abstract IStoredAppFeaturesCollection StoredAppFeatures { get; }

        internal abstract void InitializeSdk();
        internal abstract UniTask AwaitInitialConfigParsing(CancellationToken cancellationToken);

        internal abstract void Reset(bool clearNativeStorage = true, bool clearCloudStorage = true);
        internal abstract void ClearNativeStorage();
        internal abstract void Setup(TaskScheduler taskScheduler);
        internal abstract void Sync();
        internal abstract void ResetAndForceUpdate();

        internal abstract void TweakAnalyticsConfig(int eventsGroupSize, int syncTimeInterval);
        internal abstract void ResetAnalyticsConfig();
        internal abstract void TweakFirstLaunchDate(DateTime date);
        internal abstract void TweakUserLocale([NotNull] string languageTag);

        internal abstract void SetMediaSource([CanBeNull] string networkName = null, [CanBeNull] string campaignName = null, [CanBeNull] string adGroup = null);

        internal abstract void SetAttStatus(bool authorized);
        internal abstract void TrackTrustedPurchase([NotNull] TrustedPurchaseRecord record, bool? isSubscription = default, bool? isExternal = default);
        internal abstract void SetupConversionTracker(string revenuePerCountryPath, string revenueLevelsPath, string defaultCurrencyRatesPath, string subscriptionMultipliersPath);

        [CanBeNull]
        internal abstract ICampaign CampaignFor([NotNull] string eventName, [CanBeNull] IReadOnlyDictionary<string, object> customParams = null, bool silent = false);
        [CanBeNull]
        internal abstract CampaignImpression LastImpressionFor(CampaignType campaignType, [NotNull] string campaignName, [NotNull] string eventName);
        internal abstract bool IsCampaignAvailable([NotNull] string campaignName, [NotNull] string eventName, [CanBeNull] Dictionary<string, object> customParams = null);

        internal abstract void SubscribeCampaignUpdates([NotNull] string campaignName, [NotNull] Action<ICampaign> onUpdate);
        internal abstract void UnsubscribeCampaignUpdates([NotNull] string campaignName);

        internal abstract bool HasProcessedPurchase([NotNull] string productId);

        internal abstract void SetGameMode([CanBeNull] string mode);
        internal abstract void SetGameLevel(int level);
        internal abstract void SetGameMaxLevel(int maxLevel);

        internal abstract void SetUserEmail([NotNull] string email);

        internal abstract UniTask<bool> RequestSocialAuthTokenFor([NotNull] string provider, [NotNull] string token, CancellationToken cancellationToken);
        internal abstract void ResetSocialAuthToken();
        internal abstract UniTask<SyncStateResult> SaveState([CanBeNull] int? weight, CancellationToken cancellationToken);
        internal abstract UniTask<SyncStateResult> RestoreState([CanBeNull] int? weight, CancellationToken cancellationToken);

        internal abstract void TrackGdprAccessState(bool accessState);

        internal abstract void TrackAppLaunch();

        internal abstract void TrackCustomEvent([NotNull] string eventName, [CanBeNull] IReadOnlyDictionary<string, object> customParams = null);

        internal abstract void TrackImpression(CampaignType campaignType);
        internal abstract void TrackParentCampaignImpression(CampaignType campaignType);
        internal abstract void TrackProductsImpression(CampaignType campaignType, [NotNull, ItemNotNull] List<string> productIds);

        internal abstract void TrackAdsImpression(CampaignType campaignType, [NotNull] IAdsImpression impression);
        internal abstract void TrackImpressionFailFor(CampaignType campaignType, [CanBeNull] string reason);

        internal abstract void TrackClickFor(CampaignType campaignType);
        internal abstract void TrackAdsClickFor(CampaignType campaignType);
        internal abstract void TrackProductClickFor(CampaignType campaignType, [NotNull] string productId, PurchaseStore? store);
        internal abstract void TrackAdsProductClickFor(CampaignType campaignType, [NotNull] string productId);

        internal abstract void TrackSubscriptionActivation(
            bool isTrial,
            [NotNull] string productId,
            [CanBeNull] string price,
            [CanBeNull] string currency,
            [CanBeNull] string transactionId,
            [CanBeNull] string purchaseToken,
            [CanBeNull] string originalTransactionId,
            [CanBeNull] string receipt,
            bool needVerification,
            PurchaseStore store);
        internal abstract void TrackExternalSubscriptionActivation(
            bool isTrial,
            [NotNull] string productId,
            [CanBeNull] string price,
            [CanBeNull] string currency,
            [CanBeNull] string transactionId,
            [CanBeNull] string purchaseToken,
            [CanBeNull] string originalTransactionId,
            [CanBeNull] string receipt,
            bool needVerification,
            PurchaseStore store);
        internal abstract void TrackInAppFor(
            [NotNull] string productId,
            [CanBeNull] string price,
            [CanBeNull] string currency,
            [CanBeNull] string transactionId,
            [CanBeNull] string purchaseToken,
            [CanBeNull] string originalTransactionId,
            [CanBeNull] string receipt,
            bool needVerification,
            PurchaseStore store);
        internal abstract void TrackExternalInAppFor([NotNull] string productId,
            [CanBeNull] string price,
            [CanBeNull] string currency,
            [CanBeNull] string transactionId,
            [CanBeNull] string purchaseToken,
            [CanBeNull] string originalTransactionId,
            [CanBeNull] string receipt,
            bool needVerification,
            PurchaseStore store);
        internal abstract void TrackRestoredInAppFor([NotNull] string productId);
        internal abstract void TrackRestoredSubscription([NotNull] string productId);

        internal abstract void TrackIncomeTransaction([NotNull] string source, [NotNull, ItemNotNull] List<BonusInfo> bonuses, [CanBeNull] ProductInfo product = null);
        internal abstract void TrackExpenseTransaction([NotNull] List<BonusInfo> bonuses);
        internal abstract void TrackCorrectionTransaction([NotNull] List<BonusInfo> bonuses);

        internal abstract void TrackRewardGranted([NotNull] string productId);
        internal abstract void TrackFreeBonusGranted([NotNull] string productId);
        internal abstract void TrackOrdinaryProductUsed([NotNull] string productId);

        [NotNull]
        internal abstract IList<ContentItem> GetContentList([NotNull] string group, [NotNull] string key, [CanBeNull] List<string> tags = null);
        [CanBeNull]
        internal abstract ContentItem GetEarliestContent([NotNull] string group, [NotNull] string key);
        [CanBeNull]
        internal abstract ContentItem GetLatestContent([NotNull] string group, [NotNull] string key);

        internal abstract bool IsApplicationInstalled([CanBeNull] string identifier);

        public abstract void Dispose();
    }
}