using System;

namespace Magify
{
    internal static class TimestampExtensions
    {
        public static double UtcNowTimestamp => (double)DateTimeOffset.UtcNow.ToUnixTimeMilliseconds() / 1000.0d;

        public static double TimestampFromLongMills(this long timestampMills)
        {
            return timestampMills / 1000.0d;
        }

        public static double ToTimestamp(this DateTimeOffset utcDate)
        {
            return (double)utcDate.ToUnixTimeMilliseconds() / 1000.0d;
        }
    }
}