﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify
{
    public static class ConfigScopeExtensions
    {
        [NotNull, ItemNotNull]
        private static readonly IEnumerable<Enum> _flags = Enum.GetValues(typeof(ConfigScope)).Cast<Enum>();
        private static readonly int _flagsNumber = _flags.Count() - 1;

        [CanBeNull]
        public static string[] ToStringArray(this ConfigScope configScope)
        {
            if (configScope == ConfigScope.None)
            {
                return null;
            }
            var flags = _flags
                .Where(configScope.HasFlag)
                .Where(flag => Convert.ToInt64(flag) != 0); // Exclude the Default value

            var result = new List<string>(_flagsNumber);
            foreach (var flag in flags)
            {
                var memberInfo = typeof(ConfigScope).GetMember(flag!.ToString()!).FirstOrDefault();
                var enumMemberAttribute = memberInfo?.GetCustomAttribute<EnumMemberAttribute>();
                if (enumMemberAttribute != null)
                {
                    result.Add(enumMemberAttribute.Value);
                }
            }
            return result.ToArray();
        }

        internal static ConfigScope FromStringArray([CanBeNull] this string[] values)
        {
            if (values is null || values.Length == 0)
            {
                return ConfigScope.None;
            }

            var result = ConfigScope.None;

            foreach (var value in values)
            {
                var scope = value.ToEnumMember<ConfigScope>();
                result |= scope;
            }
            return result;
        }

        public static ConfigScope All()
        {
            return ConfigScope.Limits
                 | ConfigScope.ProductIds
                 | ConfigScope.Content
                 | ConfigScope.Campaigns
                 | ConfigScope.AppFeatures
                 | ConfigScope.Segmentations
                 | ConfigScope.AbTests
                 | ConfigScope.StoredAppFeatures;
        }
    }
}