﻿using System;
using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify
{
    public abstract class MagifyException : Exception
    {
        protected MagifyException()
        {
        }

        protected MagifyException([NotNull] SerializationInfo info, StreamingContext context) : base(info, context)
        {
        }

        protected MagifyException(string message) : base(message)
        {
        }

        protected MagifyException(string message, Exception innerException) : base($"{message} | With inner exception: {innerException}")
        {
        }
    }
}