using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify
{
    public enum CampaignType
    {
        [EnumMember(Value = "subscription")]
        Subscription = 0,

        [EnumMember(Value = "interstitial")]
        Interstitial = 2,

        [EnumMember(Value = "rate_and_review")]
        RateReview = 3,

        [EnumMember(Value = "rate_and_review_custom"), UsedImplicitly]
        RateReviewCustom = RateReview,

        [EnumMember(Value = "external")]
        External = 4,

        [EnumMember(Value = "cross_promo")]
        CrossPromo = 5,

        [EnumMember(Value = "notification")]
        Notification = 6,

        [EnumMember(Value = "rewarded_video")]
        RewardedVideo = 7,

        [EnumMember(Value = "banner")]
        Banner = 8,

        [EnumMember(Value = "inapp")]
        InApp = 9,

        [EnumMember(Value = "limited_time_offer")]
        LtoInApp = 10,

        [EnumMember(Value = "subscription_limited_time_offer")]
        LtoSubscription = 11,

        [EnumMember(Value = "external_limited_time_offer")]
        LtoExternal = 12,

        [EnumMember(Value = "cross_promo_limited_time_offer")]
        LtoCrossPromo = 13,

        [EnumMember(Value = "rewarded_video_limited_time_offer")]
        LtoRewardedVideo = 14,

        [EnumMember(Value = "bonus_inapp")]
        Bonus = 15,

        [EnumMember(Value = "bonus_limited_time_offer")]
        LtoBonus = 16,

        [EnumMember(Value = "mixed")]
        Mixed = 17,

        [EnumMember(Value = "mixed_limited_time_offer")]
        LtoMixed = 18
    }

    internal static class CampaignTypeUtils
    {
        public static readonly CampaignType[] RewardedCampaignTypes =
        {
            CampaignType.RewardedVideo,
            CampaignType.LtoRewardedVideo,
            CampaignType.Mixed,
            CampaignType.LtoMixed
        };
    }
}